#include <malloc.h>
#include "bitmap.hpp"
#include "gl.h"


Bitmap8::~Bitmap8()
{
	delete palette;
}

DWORD Bitmap8::GetPixel( int x, int y )
{
	if( x < 0 || x >= width || y < 0 || y >= height )
		return 0;
	
	return ((DWORD)line[y][x]) & 0xff;
}
	
void Bitmap8::PutPixel( int x, int y )
{
	if( clip ){
		if( x < cl || x >= cr || y < ct || y >= cb )
			return;
	}
	
	int pixel = color;
	
	if( drawMode & XorMode )
		pixel ^= *( line[y] + x );
	else if( drawMode & AlphaMode )
		pixel = pixel;	// how to do?
	
	*(char*)( line[y] + x ) = pixel;
	
}

/*int Bitmap8::FindColor( )
{
}
*/
//color = 0x00rrggbb or 0x800000cc
void Bitmap8::SetColor( int color )
{
	if( color & 0x80000000 ){
		Bitmap8::color = color & 0xff;
	}
	else{
		int r, g, b;
		r = color >> 16;
		g = (color >> 8) & 0xff;
		b = color & 0xff;
		
		Bitmap8::color = 80;
	OutputDebugString( "in bitmap8::setcolor" );
	}
}

void Bitmap8::SetColorKey( int color )
{
	if( color < 256 && color >= 0 )
		colorKey = color;
}

// void Bitmap8::BlitMask( ......... )
BLITMASK( 8 )


void Bitmap8::Blit( Bitmap* dest, int x, int y, int sx, int sy, int w, int h )
{
	BLITCLIP()
	
	if( dest == this ){
		if( y > sy )	// reverse
			BlitInside8( x, y, sx, sy, w, h );
		else if( y == sy && sx < x )
			BlitInside8( x, y, sx, sy, w, h );
		else
			BlitOutside8( (Bitmap8*)dest, x, y, sx, sy, w, h );
	}
	else{
		if( dest->colorDepth == 16 || dest->colorDepth == 15 )
			BlitMaskedTo16( (Bitmap16*)dest, x, y, sx, sy, w, h );
		else
			BlitOutside8( (Bitmap8*)dest, x, y, sx, sy, w, h );
	}
}

void Bitmap8::BlitInside8( int x, int y, int sx, int sy, int w, int h )
{
	OutputDebugString("in blitinside8" );
	
	char** line = Bitmap8::line;

	__asm{
	push es
	mov ax, ds
	mov es, ax
	
	mov eax, sy	/* y value go from high to low */
	mov ebx, h
	dec ebx
	add eax, ebx
	mov sy, eax
	add y, ebx
	inc ebx
	
	mov ecx, w	/* x value go from high to low */
	dec ecx
	add sx, ecx
	add x, ecx
	inc ecx
	
	std
	mov edx, y
	shl eax, 2
	shl edx, 2
	cmp ecx, 3
	jg blitinside8_dwloop
	
blitinside8_b: 	/* the width is less than 4 */
	mov esi, line	/* source bitmap */
	mov edi, esi
	mov esi, dword ptr [esi+eax]
	add esi, sx
	mov edi, dword ptr [edi+edx]
	add edi, x
	mov ecx, w
	repnz movsb
	sub eax, 4
	sub edx, 4
	dec ebx
	jnz blitinside8_b
	jmp blitinside8_end
	
blitinside8_dwloop:	/* the width is no less than 4 */
	mov esi, line	/* source bitmap */
	mov edi, esi
	mov esi, dword ptr [esi+eax]
	add esi, sx
	mov edi, dword ptr [edi+edx]
	add edi, x
	mov ecx, w
	and ecx, 3
	repnz movsb
	sub esi, 3
	mov ecx, w
	sub edi, 3
	shr ecx, 2
	repnz movsd
	sub eax, 4
	sub edx, 4
	dec ebx
	jnz blitinside8_dwloop
	
blitinside8_end:
	pop es
	}
}

void Bitmap8::BlitOutside8( Bitmap8* dest, int x, int y, int sx, int sy, int w, int h )
{
	OutputDebugString("in blitOutside8" );
	char** dline = dest->line;
	char** sline = Bitmap8::line;

	__asm{
	push es
	mov ax, ds
	mov es, ax
	
	mov ebx, h
	mov eax, y
	mov edx, sy
	shl eax, 2
	shl edx, 2
	cld
	
	cmp w, 3 	/* if the width is larger than 3 then use MOVSD */
	jg blitoutside8_dw
blitoutside8_b: 	/* have to use movsb */
	mov esi, sline	/* source bitmap */
	mov esi, [esi+edx]
	add esi, sx
	mov edi, dline	/* destination bitmap */
	mov edi, [edi+eax]
	add edi, x
	mov ecx, w
	repnz movsb
	add eax, 4
	add edx, 4
	dec ebx
	jnz blitoutside8_b
	jmp blitoutside8_end
	
blitoutside8_dw:
	mov esi, sline	/* source bitmap */
	mov esi, [esi+edx]
	add esi, sx
	mov edi, dline	/* destination bitmap */
	mov edi, [edi+eax]
	add edi, x
	mov ecx, w
	and ecx, 3
	repnz movsb
	mov ecx, w
	shr ecx, 2
	repnz movsd
	add edx, 4
	add eax, 4
	dec ebx
	jnz blitoutside8_dw
	
blitoutside8_end:
	pop es
	}
}

// blit with source colorkey
void Bitmap8::BlitMasked8( Bitmap8* dest, int x, int y, int sx, int sy, int w, int h )
{
	char** dline = dest->line;
	char** sline = Bitmap8::line;
	int colorkey = colorKey;
	
	__asm{
	push es
	mov ax, ds
	mov es, ax
	
	xor ebx, ebx
	mov eax, colorkey
	mov edx, sy
	shl y, 2
	shl edx, 2
	
blitmasked8_b:
	mov esi, sline	/* source bitmap */
	mov esi, [esi+edx]
	add esi, sx
	mov edi, dline	/* destination bitmap */
	add edi, y
	mov edi, [edi]
	add edi, x
	mov ecx, w
blitmasked8_loop:
	mov bl, byte ptr ds:[esi]	/* read pixel */
	inc esi
	cmp bl, al					/* is colorkey? */
	je blitmasked8_skip
	mov byte ptr es:[edi], bl	/* write pixel */
blitmasked8_skip:
	inc edi
	loop blitmasked8_loop
	add y, 4
	add edx, 4
	dec h
	jnz blitmasked8_b
	
	pop es
	}
}

// blit from 256color bitmap to 64kcolor bitmap
// source color key, but NO alpha blending
void Bitmap8::BlitMaskedTo16( Bitmap16* dest, int x, int y, int sx, int sy, int w, int h )
{
	char** dline = dest->line;
	char** sline = Bitmap8::line;
	int *pal = palette->screenPal;
	int colorkey = colorKey;
/*pal[0] = 1;
extern void test( void );
#pragma aux test =
	mov edx, pal
	mov ebx, 0 
	mov eax, [edx + ebx*4 ]
	mov colorkey, eax 
	modify[ eax ebx edx ];
test();	
printf(test pal: %dn", colorkey );
return;	
*/
	__asm{
	push es
	mov ax, ds
	mov es, ax
	
	xor ebx, ebx
	mov eax, colorkey
	mov edx, pal
	shl x, 1
	shl y, 2
	shl sy, 2
	
blitmaskto16_b:
	mov esi, sline	/* source bitmap */
	add esi, sy
	mov esi, [esi]
	add esi, sx
	mov edi, dline	/* destination bitmap */
	add edi, y
	mov edi, [edi]
	add edi, x
	mov ecx, w
blitmaskto16_loop:
	xor ebx, ebx
	mov bl, byte ptr ds:[esi]	/* read pixel */
	inc esi
	cmp bl, al					/* is colorkey? */
	je blitmaskto16_skip
	mov ebx, [edx + ebx*4]
	mov word ptr es:[edi], bx	/* write pixel */
blitmaskto16_skip:
	add edi, 2
	loop blitmaskto16_loop
	add y, 4
	add sy, 4
	dec h
	jnz blitmaskto16_b
	
	pop es
	}
}

// clear with color, color is index ( not rgb )
void Bitmap8::Clear( int l, int t, int w, int h, int color )
{
	char** dline = line;
	OutputDebugString("clear");
	if( clip ){
		if( l < cl ){
			w -= cl - l;
			l = cl;
		}
		if( t < ct ){
			h -= ct - t;
			t = ct;
		}
		if( l + w > cr )
			w = cr - l;
		if( t + h > cb )
			h = cb - t;
	}
	else{
		if( l < 0 ){
			w += l;
			l = 0;
		}
		if( t < 0 ){
			h += t;
			t = 0;
		}
		if( l + w > width )
			w = width - l;
		if( t + h > height )
			h = height - t;
	}
	
	__asm{
	push es
	mov ax, ds
	mov es, ax
	
	mov eax, color	/* duplicate color 4 times */
	mov ah, al
	mov ebx, eax
	shl eax, 16
	mov ax, bx
	
	mov edx, t
	cld
	shl edx, 2
	mov ebx, h
	mov esi, w
	
clear8_loop:
	mov edi, dline	/* get line address */
	mov edi, [edi+edx]
	add edi, l
	
	mov ecx, esi
	shr ecx, 1
	jnc clear8_nobyte
	stosb	/* clear an odd byte */
	
clear8_nobyte:
	shr ecx, 1
	jnc clear8_noword
	stosw 	/* clear an odd word */
	
clear8_noword:
	jz clear8_nolong
	repnz stosd	/* clear the rest of the line */
	
clear8_nolong:
	add edx, 4
	dec ebx
	jnz clear8_loop
	
	pop es
	}
}

Bitmap* Bitmap8::ConvertFormat( int colordepth )
{
	return NULL;
}


